//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace Testing
{
	interface IFunctions
	{
		void A();
		void B();
		void C();
	}
	abstract class Function : IFunctions
	{
		public void A()
		{
			Console.WriteLine("Jestem w A");
		}
		public abstract void B();
		public abstract void C();
	}

	// Klasa abstrakcyjna
	abstract class Point
	{
		protected int x = 0; 
		protected int y = 0;
		// Metody abstrakcyjne
		public abstract void Increment();
		public abstract void Decrement();

		// Waciwoci abstrakcyjne
		public abstract int X
		{
			get;
		}

		public abstract int Y
		{
			get;
		}
	}

	class NewPoint: Point
	{
		public override void Increment() 
		{
			x++;
			y++;   
		}   
		public override void Decrement() 
		{
			x--;
			y--;   
		}   

		public override int X
		{
			get 
			{
				return x;
			}
		}

		public override int Y
		{
			get
			{
				return y;
			}
		}
	}

	class NewFunction : Function
	{
		public override void B()
		{
			Console.WriteLine("Jestem w B");
		}
		public override void C()
		{
			Console.WriteLine("Jestem w C");
		}
	}

	class AbstractMain
	{
		public static void Main() 
		{
			NewPoint p = new NewPoint();
			p.Increment();
			p.Increment();
			p.Decrement();
			Console.WriteLine("x = {0}, y = {1}", p.X, p.Y);
			NewFunction f = new NewFunction();
			IFunctions i = (IFunctions)f;
			i.A();
			i.B();
			i.C();
		}
	}
}